#pragma once

#include "SampleClasses.h"
#include "Helper.h"

#include <vector>
#include <map>
#include <deque>
using namespace std;


class MovingObjectBase {
public:
	MovingObjectBase();
	MovingObjectBase(ObjectType typ, double ts, Point centre);

	void Touch(bool b = true) {
		m_Touched = b;
	}

	// reset all internal data
	virtual void Reset();

	// look if estimated position and given position / type / size match: if so update object
	virtual bool UpdateMatchingObject(double ts, ObjectType typ, int x, int y, int /*scaleFactor*/, int /*subType*/);

	// determine fly-by and other dynamic data
	void CalcDynamicData(double shotAngle);

	// unique ID of this object
	unsigned int m_ID;
	// framecount the values where calculated for
	double m_TimeStamp;
	// used to determine if an object still exists
	bool m_Touched;
	// Type of this object
	ObjectType m_Typ;
	// size - max distance from centre to object border
	double m_Size;
	// center point from latest frame
    Point m_LastCentre;
	// estimated center point for next frame
	Point m_Centre;
    
	// for calculating speed
	double m_DxSum, m_DySum;
	// number of data points in sums
	double m_DCount;
	// speed vector
	Point m_Speed;
	// direct distance to my ship
	double m_Dist;

	// fly-by point
	Point m_InterP;
	// distance to fly-by point; 999999.0 if already passed me
	double m_ClosestDist;
	// 0: doesn't hit me; time to hurt otherwise!
	double m_Time2Impact;
	// could hit me soon - shot first!
	bool m_DeadlyObject;

protected:
	// update position and speed after object was matched
	virtual void Update(double ts, int x, int y);

	// next available ID
	static unsigned int sm_NextID;
};

class ShootableObject : public MovingObjectBase {
public:
	ShootableObject();
	ShootableObject(ObjectType typ, double ts, Point centre, int sf);

	// look if estimated position and given position / type / size match: if so update object
	virtual bool UpdateMatchingObject(double ts, ObjectType typ, int x, int y, int scaleFactor, int /*subType*/);

	// calc hit point with given shot angle
	void CalcAimPoint(double shotAngle, double deltaT, Point &aimPoint, double &distance2Aim, double &aimAngle, double &aimAngleOffset, double &time2Hit);
	// estimate real time to turn to target and for shot to hit
	bool EstimateRealHitTime(double shotAngle);

	// scale factor
	int m_Sf;

	// I have to shot this aim point to hit!
	Point m_AimPoint;
	// angle to estimated aim point
	double m_AimAngle;
	// angle offset from my view to the aim point
	double m_AimAngleOffset;
	// time to turn to aim point
	double m_Time2Turn, m_Time2TurnLast;
    // time to wait at current position before shooting
    double m_Time2Wait, m_Time2WaitLast;
	// time for shot to reach target
	double m_Time2Hit, m_Time2HitLast;
	// while estimating hit time it was faster to turn left: 1 or right: -1
	long m_FasterTurnToHit, m_FasterTurnToHitLast;
	// distance to aim point
	double m_Distance2Aim;

	// framecount when I shot at it most recently
	double m_EstimatedBlowTime;
	// max number of shots to fire at his target at a time
	long m_MaxShots;
	// number of shots at his target on the way
	long m_Shots;
};


class MyAsteroid : public ShootableObject {
public:
	// new asteriod
	MyAsteroid();
	MyAsteroid(double ts, const Asteroid&);
    // UFO
    MyAsteroid(double ts, int x, int y, int sf);

	// look if estimated position and given position / type / size match: if so update object
	virtual bool UpdateMatchingObject(double ts, ObjectType typ, int x, int y, int scaleFactor, int subType);

	// special sub type of this object: ASTRO = 1 - 4
	int m_SubType;
};


class MyShot : public MovingObjectBase {
public:
	// new shot
	MyShot();
	MyShot(double ts, const Shot&, long shotAngleIndex);

	// index to estimated shot angle
	long m_ShotAngleIndex;
    // time before shot hits (hopefully)
    double m_Time2Live;
    // 0: under way; 1: should hit in next frame (i.e. disappear); > 1: missed!
    long m_ShouldHit;
	// ID of my target
	long m_TargetID;

protected:
	// update time2live + rest
	virtual void Update(double ts, int x, int y);
};
